//  File: KifOperator.java

package jkp;

import java.lang.*;
import jbf.*;


/**
 *  The class for KIF operator.
 *  @version 1.0 Nov 12 1996
 *  @author  <A href="http://www.cs.umbc.edu/~xluan1/">Xiaocheng LUAN</A>
 */
public class KifOperator extends KifObj {

	private String _opString;


	public KifOperator(int opID)
	{
		setType(opID);
		_opString = KifOperator.opToString(opID);
	}


	public String
	toString()
	{
		return _opString;
	}


	public static String 
	opToString(int opID) throws KifRTException
	{
		for(int i=0; i<_kifOpString.length; i++)
			if(_kifOpString[i]._opID == opID)
				return new String(_kifOpString[i]._opString);
		
		throw (new KifRTException("No such Operator ID !"));
	}


	private static KifOpString _kifOpString[] = {

		new KifOpString(KifObj.KIFOP_LISTOF,	"LISTOF"),
		new KifOpString(KifObj.KIFOP_QUOTE,		"QUOTE"),
		new KifOpString(KifObj.KIFOP_IF,		"IF"),
		new KifOpString(KifObj.KIFOP_COND,		"COND"),

		new KifOpString(KifObj.KIFOP_SENTEQ,	"="),
		new KifOpString(KifObj.KIFOP_SENTNOTEQ,	"\\="),
		new KifOpString(KifObj.KIFOP_NOT,		"NOT"),
		new KifOpString(KifObj.KIFOP_AND,		"AND"),
		new KifOpString(KifObj.KIFOP_OR,		"OR"),
		new KifOpString(KifObj.KIFOP_IMPLIES,	"=>"),
		new KifOpString(KifObj.KIFOP_IMPLIED,	"<="),
		new KifOpString(KifObj.KIFOP_EQUIV,		"<=>"),
		new KifOpString(KifObj.KIFOP_FORALL,	"FORALL"),
		new KifOpString(KifObj.KIFOP_EXISTS,	"EXISTS"),

		new KifOpString(KifObj.KIFOP_DEFOBJECT,	"DEFOBJECT"),
		new KifOpString(KifObj.KIFOP_DEFUNCTION,"DEFUNCTION"),
		new KifOpString(KifObj.KIFOP_DEFRELATION,"DEFRELATION"),

		new KifOpString(KifObj.KIFOP_NUMEQ,		"="),
		new KifOpString(KifObj.KIFOP_NUMNEQ,	"\\="),
		new KifOpString(KifObj.KIFOP_LESS,		"<"),
		new KifOpString(KifObj.KIFOP_GREATER,	">"),
		new KifOpString(KifObj.KIFOP_EQLESS,	"=<"),
		new KifOpString(KifObj.KIFOP_EQGREATER,	">=")
	};
}



class KifOpString {
	public int _opID;
	public String _opString;

	public KifOpString(int opID, String opString)
	{
		_opID = opID;
		_opString = opString;
	}
}
