//  File: KifLogSent.java

/*  Set tabstop = 4 to read this file.
*
*   Maintanence History:
*   . Feb. 97:
*     - Distribute some methods to its subclasses, including KifNegation,
*       KifEquivalence, KifConjunction, KifDisjunction, KifImplication.
*/

package jkp;

import java.lang.*;
import jbf.*;


/**
 * The base base class for KIF logical sentences.
 * @author  <A href="http://www.cs.umbc.edu/~xluan1/">Xiaocheng LUAN</A>
 */
public class KifLogSent extends KifSent {

	protected KifSent	_sentence;
	protected KifSeq  	_sentSeq;

	public KifLogSent()
	{
		_sentence = null;
		_sentSeq = null;
	}


	public KifSent
	sentence()
	{
		return _sentence;
	}

	public KifSeq
	sentenceSeq()
	{
		return _sentSeq;
	}


	/*  Moved to KifEquivalence.java
	public KifSent 
	leftSent()
	{
		return _sentence;
	}


	public KifSent 
	rightSent()
	{
		return (KifSent)_sentSeq.car();
	}
	*/


	/*	Moved to class KifImplication
	public KifSeq
	antecedenceSeq()
	{
		return _sentSeq;
	}


	public KifSent
	consequenceSent()
	{
		return _sentence;
	}
	*/


	/*	Move to class KifConjunction
	public KifSeq
	conjuncSeq()
	{
		return _sentSeq;
	}
	*/


	/*  Move to class KifDisjunction
	public KifSeq
	disjuncSeq()
	{
		return _sentSeq;
	}
	*/


}


