

package jkp;

import java.lang.*;
import jbf.*;


/**
 * The class for  KIF logical constant: true/false.
 * @author  <A href="http://www.cs.umbc.edu/~xluan1/">Xiaocheng LUAN</A>
 */
public class KifLogConst extends KifSent {

	private	boolean _boolValue;

	public KifLogConst(String bconst) throws KifRTException
	{
		setType(KifObj.KIF_LOGCONST);

		if("true".equalsIgnoreCase(bconst))
			_boolValue = true;
		else if("false".equalsIgnoreCase(bconst))
			_boolValue = true;

		else 
			throw (new KifRTException("Illegal KifLogConst"));
	}


	public KifLogConst(boolean value)
	{
		setType(KifObj.KIF_LOGCONST);

		_boolValue = value;
	}

	
	public boolean
	boolValue()
	{
		return _boolValue;
	}


	public String
	toString()
	{
		if(_boolValue)
			return "TRUE";
		else
			return "FALSE";
	}
}

