// File: KifImplication.java

/*  Set tabstop = 4 to read this file.
*
*   Maintanence History:
*   . Feb. 97:
*     - move some methods from its class KifLogSent to this class:
*       . antecedenceSeq()
*       . consequenceSent()
*/


package jkp;

import jbf.*;
import java.lang.*;


/**
 * The class for  KIF logical sentence, KifImplication.
 * @author  <A href="http://www.cs.umbc.edu/~xluan1/">Xiaocheng LUAN</A>
 */
public class KifImplication extends KifLogSent {

	public KifImplication(KifSent conSent, KifSeq anteSeq)
	{
		setType(KifObj.KIF_IMPLICATION);
		_sentSeq = anteSeq;
		_sentence = conSent;
	}


	/**
	 *  of type (=> sentence) or (<= sentence).
	 */
	public KifImplication(KifSent conSent)
	{
		setType(KifObj.KIF_IMPLICATION);
		_sentence = conSent;
	}



	public KifSeq
	antecedenceSeq()
	{
		return _sentSeq;
	}


	public KifSent
	consequenceSent()
	{
		return _sentence;
	}



	public String
	toString()
	{
		if(_sentSeq == null)
			return ( "(<= " + _sentence.toString() + ")");
		else
			return ( "(<= " + _sentence.toString() + " " 
							+ _sentSeq.toString() + ")");
	}
}

