// File: KifHornSent

package jkp;

import jbf.*;
import java.lang.*;


/**
 *  The class for  KIF horn clause.
 *  @version 1.0 Nov 11 1996
 *  @author  <A href="http://www.cs.umbc.edu/~xluan1/">Xiaocheng LUAN</A>
 */
public class KifHornSent extends KifLogSent {

	public KifHornSent(KifRelSent head, KifSeq condition)
	{
		setType(KifObj.KIF_HORNSENT);
		_sentence = head;
		_sentSeq  = condition;
	}

	public KifHornSent(KifRelSent head)
	{
		setType(KifObj.KIF_HORNSENT);
		_sentence = head;
	}

	public KifHornSent(KifSeq condition)
	{
		setType(KifObj.KIF_HORNSENT);
		_sentSeq  = condition;
	}


	public KifSeq
	antecedenceSeq()
	{
		return _sentSeq;
	}


	public KifSent
	consequenceSent()
	{
		return _sentence;
	}



	public String
	toString()
	{
		if(_sentSeq == null)
			return "(" + _sentence.toString() + " <=)";

		return "(" + _sentence.toString() + " <= " + 
					_sentSeq.toString() + ")";
	}
}

