
//  File: KifFunTerm.java


/*  Set tabstop = 4 to read this file.
*
*   Maintanence History:
*/


package jkp;

import jbf.*;
import java.lang.*;


/**
 * The class for KIF functional term
 * @author  <A href="http://www.cs.umbc.edu/~xluan1/">Xiaocheng LUAN</A>
 */
public class KifFunTerm extends KifTerm {

	private KifSeq _termSeq;

	public KifFunTerm(String termString)
	{
		setType(KifObj.KIF_FUNTERM);
		_termString = termString;
		_termSeq = null;
	}


	public KifFunTerm(String funconst, KifSeq termSeq)
	{
		setType(KifObj.KIF_FUNTERM);
		_termString = funconst;
		_termSeq = termSeq;
	}


	/**
	 * @return Return the functional constant, which is the name.
	 */
	public String
	funconst()
	{
		return _termString;
	}


	/**
	 * @return Return the term sequence(arguments) of this functional term.
	 */
	public KifSeq
	termSeq()
	{
		return _termSeq;
	}


	public String
	toString()
	{
		if(_termSeq != null)
			return("(" +  _termString + " " + _termSeq.toString() + ")");

		return "(" + _termString + ")";
	}
}



