// File: KifEquivalence.java

/*  Set tabstop = 4 to read this file.
*
*   Maintanence History:
*   . Feb. 97:
*     - move some methods from its super class, KifLogSent to this class:
*       . leftSent()
*       . rightSent()
*/



package jkp;

import jbf.*;
import java.lang.*;


/**
 * The class for  KIF logical sentence, KifEquivalence.
 * @author  <A href="http://www.cs.umbc.edu/~xluan1/">Xiaocheng LUAN</A>
 */
public class KifEquivalence extends KifLogSent {

	public KifEquivalence(KifSent sent1, KifSent sent2)
	{
		setType(KifObj.KIF_EQUIVALENCE);
		_sentence = sent1;
		_sentSeq = new KifSeq(sent2);
	}


	public KifSent
	leftSent()
	{
		return _sentence;
	}


	public KifSent
	rightSent()
	{
		return (KifSent)_sentSeq.car();
	}


	public String
	toString()
	{
		return ( "(<=> " + _sentence.toString() + " " 
						+ _sentSeq.toString() + ")");
	}
}

