// File: KifDisjunction.java


/*  Set tabstop = 4 to read this file.
*
*   Maintanence History:
*   . Feb. 97:
*     - move the method disjuncSeq(), from its class KifLogSent to this class.
*/


package jkp;

import jbf.*;
import java.lang.*;


/**
 * The class for  KIF logical sentence, negation.
 * @author  <A href="http://www.cs.umbc.edu/~xluan1/">Xiaocheng LUAN</A>
 */
public class KifDisjunction extends KifLogSent {

	public KifDisjunction(KifSeq sentSeq)
	{
		setType(KifObj.KIF_DISJUNCTION);
		_sentSeq = sentSeq;
	}


	public KifDisjunction(KifSent sent, KifSeq sentSeq)
	{
		setType(KifObj.KIF_DISJUNCTION);
		_sentSeq = new KifSeq(sent, sentSeq);
	}


    public KifSeq
	disjuncSeq()
	{
		return _sentSeq;
	}


	public String
	toString()
	{
		return ( "(" + "OR" + " " +  _sentSeq.toString() + ")");
	}
}

