// File: KifConjunction.java


/*  Set tabstop = 4 to read this file.
*
*   Maintanence History:
*   . Feb. 97:
*     - move the method conjuncSeq(), from its class KifLogSent to this class.
*/


package jkp;

import jbf.*;
import java.lang.*;


/**
 * The class for  KIF logical sentence, Conjunction.
 * @author  <A href="http://www.cs.umbc.edu/~xluan1/">Xiaocheng LUAN</A>
 */
public class KifConjunction extends KifLogSent {

	public KifConjunction(KifSeq sentSeq)
	{
		setType(KifObj.KIF_CONJUNCTION);
		_sentSeq = sentSeq;
	}


	public KifConjunction(KifSent sent, KifSeq sentSeq)
	{
		setType(KifObj.KIF_CONJUNCTION);
		_sentSeq = new KifSeq(sent, sentSeq);
	}



	public KifSeq
	conjuncSeq()
	{
		return _sentSeq;
	}




	public String
	toString()
	{
		return ( "(" + "AND" + " " +  _sentSeq.toString() + ")");
	}
}

