import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.io.ByteArrayInputStream;
import JavaAgent.resource.fopl.*;

class LblTextField extends Panel {

  Label lbl;
  TextField tf;

  LblTextField(String lblText, int tfSize) {
    setLayout(new FlowLayout(FlowLayout.RIGHT));
    lbl = new Label(lblText);
    tf = new TextField(tfSize);
    add(lbl);
    add(tf);
  }
}

class TwoLblTextField extends Panel {

  LblTextField tf1, tf2;

  TwoLblTextField(String lbl1, String lbl2, int tfSize) {
    setLayout(new BorderLayout());
    tf1 = new LblTextField(lbl1, tfSize);
    tf2 = new LblTextField(lbl2, tfSize);
    add("North", tf1);
    add("South", tf2);
  }
}

public class Unify extends Applet {

  TwoLblTextField
    tField = new TwoLblTextField("Term1:", "Term2:", 70),
    bField = new TwoLblTextField("Substitution:", "Result:", 70);
  Button ub = new Button("Unify");

  public void init() {
    setLayout(new BorderLayout());
    ub.addActionListener(new ubL());
    add(tField, BorderLayout.NORTH);
    add(bField, BorderLayout.SOUTH);
    bField.tf1.tf.setEditable(false);
    bField.tf2.tf.setEditable(false);
    add(new Label("                          "), BorderLayout.WEST);
    add(new Label("                          "), BorderLayout.EAST);
    add(ub, BorderLayout.CENTER);
    Variable.printWithIndex = false;
  }

  class ubL implements ActionListener {
    public void actionPerformed(ActionEvent ae) {
      Term t1, t2;
      bField.tf1.tf.setText("");
      bField.tf2.tf.setText("");
      // parsing the first Term into t1:
      try {
	YYparse parser = new YYparse(new YYlex(new ByteArrayInputStream(
            ("term " + tField.tf1.tf.getText() + ' ').getBytes())));
	parser.yyparse();
	t1 = (Term)parser.parseResult;
      } catch (Exception t1e) {
	bField.tf2.tf.setText("Term1: " + t1e.getMessage());
	return;
      }
      // parsing the second Term into t2:
      try {
	YYparse parser = new YYparse(new YYlex(new ByteArrayInputStream(
            ("term " + tField.tf2.tf.getText() + ' ').getBytes())));
	parser.yyparse();
	t2 = (Term)parser.parseResult;
      } catch (Exception t2e) {
	bField.tf2.tf.setText("Term2: " + t2e.getMessage());
	return;
      }
      // unify the two terms and display the result:
      try {
	Substitution s = new Substitution();
      } catch (Exception ue) {
	bField.tf1.tf.setText(ue.getMessage());
      }	
    }
  }

}
