package SModeling;

/**	
 * Class which represents a line defined by a point and a unit direction
 * vector.<p>
 *
 * <hr>
 * Copyright (c) 1995, H. Robert Frost, Stanford University.
 * All rights reserved.<p>
 * Copyright (c) 1996, H. Robert Frost, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * <hr>
 * @author <A HREF="http://cdr.stanford.edu/html/people/frost-bio.html"> Rob Frost</A>
 * @version 5/21/96 for Java(tm) Language Version 1.0.2
 */

class p_vline {

  public hpoint point;
  public hpoint vector;
  
  /**
   * Construct given point and vector
   * @param p hpoint representing a point in space.
   * @param v hpoint representing a direction vector.
   */

  public p_vline (hpoint p, hpoint v) {
    point = p;
    vector = v;
  }
  
  /**
   * Construct from two endpoints
   * @param p1 First endpoint.
   * @param p2 Second endpoint.
   * @param dummy Dummy variable to distinguish constructors.
   */

  public p_vline (hpoint p1, hpoint p2, boolean dummy) {
    point = p1;
    vector = p2.diff(point);
    vector.normalize();
  }

}
