package SModeling;

import java.util.Vector;

/**
 * Represents a line between two verticies which are represented by 
 * their indicies in the verticies Vector associated with the model. 
 *
 * <hr>
 * Copyright (c) 1995, H. Robert Frost, Stanford University.
 * All rights reserved.<p>
 * Copyright (c) 1996, H. Robert Frost, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * <hr>
 * @author <A HREF="http://cdr.stanford.edu/html/people/frost-bio.html"> Rob Frost</A>
 * @version 5/21/96 for Java(tm) Language Version 1.0.2
 */

public class line {
 
  /**
   * Indicies of verticies with define the line.
   * (indicies start with 1)
   */

  public int p1, p2;

  /**
   * Indicies of faces which border the line.
   * (indicies start with 1)
   */

  public int f1, f2;

  /**
   * Is the line currently visible?
   */

  public boolean visible;

  /**
   * Is the line currently blocked?
   */

  public boolean blocked = false;

  /**
   * Set of intersection points on the line (for blocked lines).
   */

  public Vector intersections = new Vector();

  /**
   * Creates a new line defined by two endpoints stored in an external array.
   * @param a Index in array of first endpoint (starts with 1).
   * @param b Index in array of second endpoint (starts with 1).
   */

  public line (int a, int b) {
    visible = true;
    p1 = a;
    p2 = b;
  }

}
