package SModeling;

/**
 *  Class for representing a fixture point (x,y,z position and inward normal
 *  vector).<p>
 * 
 * <hr>
 * Copyright (c) 1995, H. Robert Frost, Stanford University.
 * All rights reserved.<p>
 * Copyright (c) 1996, H. Robert Frost, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * <hr>
 * @author <A HREF="http://cdr.stanford.edu/html/people/frost-bio.html"> Rob Frost</A>
 * @version 5/21/96 for Java(tm) Language Version 1.0.2
 */

public class fix_point {
  
 /**
  * Location on the model.
  */
  public hpoint point;

 /**
  * Index of the face on which the point is located.
  */
  public int face_index;

  /**
   * Create a fixture point at the specified point on the specified face.
   * @param hp Point on model.
   * @param face Index of face on which the point is located.
   */
  public fix_point( hpoint hp, int face) {
    point = hp;
    face_index = face;
  }

  /**
   * Get the x coord. of the point.
   * @return X coordinate.
   */
  public float x() {
    return point.getx();
  }

  /**
   * Get the y coord. of the point.
   * @return Y coordinate.
   */
  public float y() {
    return point.gety();
  }

  /**
   * Get the z coord. of the point.
   * @return Z coordinate.
   */
  public float z() {
    return point.getz();
  }

}

