package SModeling;

import java.util.Vector;

/**
 * Represents a planar convex polygonal face. Each face is represented by a
 * set of verticies in counterclockwise order.<p>
 * 
 * <hr>
 * Copyright (c) 1995, H. Robert Frost, Stanford University.
 * All rights reserved.<p>
 * Copyright (c) 1996, H. Robert Frost, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * <hr>
 * @author <A HREF="http://cdr.stanford.edu/html/people/frost-bio.html"> Rob Frost</A>
 * @version 5/21/96 for Java(tm) Language Version 1.0.2
 */


public class face {

  Vector verticies; /* array of vertex indicies, listed clockwise from 
		       outside of face */
  Vector lines; /* contains indicies of bounding lines */
  
  /**
   * Is the face currently visible?
   * Determined by surface normal direction, may be visible but blocked
   * for concave models.
   */
  public boolean visible = true;

  /**
   * Is the face blocked by another face?
   * Must be visible to be blocked.
   */
  public boolean blocked = false;
 
  /**
   * Inward normal vector.
   * Represents current orientation of face.
   */
  public hpoint in_norm;
 
   /**
    * Inward normal for unrotated face, computed before any rotations.
    */
  public hpoint abs_in_norm;

  /**
   * Point where view vector (at the mouse location) intersects the
   * plane of the face, may not be on face.
   */
  public hpoint intersect;
  
  /**
   * Create with initial capacity and increment for both the verticies
   * and lines Vectors.
   * @param cap Initial capacity for Vectors.
   * @param incr Increment for resizing Vectors.
   */

  public face(int cap, int incr) {
    verticies = new Vector(cap, incr);
    lines = new Vector(cap,incr);
  }
  
  /**
   * Add vertex index to face.
   * @param v Index of added vertex, represents location in external array of verticies.
   */

  public void addV (int v) {
    Integer i = new Integer(v);
    verticies.addElement(i);
  }

  /**
   * Add edge index to face
   * @param e Index of added edge, represents location in external array of edges.
   */
 
  public void addE (int e) {
    Integer i = new Integer(e);
    lines.addElement(i);
  }

  /**
   * Get vertex index stored at a given position.
   * @param pos Internal position of desired vertex index.
   * @return The index of the vertex at the specified position.
   */

  public int getV (int pos) {
    if(pos < verticies.size()) {
      Integer i = (Integer)verticies.elementAt(pos);
      return i.intValue();
    } else {
      return 0;
    }
  }

  /**
   * Get edge index stored at a given position.
   * @param pos Internal position of desired edge index.
   * @return The index of the edge at the specified position.
   */

  public int getE (int pos) {
    if(pos < lines.size()) {
      Integer i = (Integer)lines.elementAt(pos);
      return i.intValue();
    } else {
      return 0;
    }
  }
  
  /**
   * Return the number of verticies which define the face.
   * @return The number of verticies.
   */

  public int size () {
    return verticies.size();
  }
  
}
