package SModeling;

/** 
 * Class which contains methods for extracting the fixture point information
 * from an object of class model and putting into the correct format for
 * submission to the CMU fixture design and analysis tool. Emulates a POST 
 * method forms submission.<p>
 *
 * <hr>
 * Copyright (c) 1995, H. Robert Frost, Stanford University.
 * All rights reserved.<p>
 * Copyright (c) 1996, H. Robert Frost, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * <hr>
 * @author <A HREF="http://cdr.stanford.edu/html/people/frost-bio.html"> Rob Frost</A>
 * @version 5/21/96 for Java(tm) Language Version 1.0.2
 */

public class PostParams {
 
 /**
   * This creates a string containing post method name/value pairs for 
   * submission to the CMU Fixture Design Tool.
   * @param M The model to construct the post parameters for
   * @param dim Dimensionality for analysis, true for 3D, false for planar
   * @param type Directionality for analysis, true for form closure, false
   * for directional
   * @param dir_vector The vector for directional analysis
   * @return String containing ampersand delimited name/value pairs
   */

  public static String getPostparams(model M, boolean dim, boolean type, 
				     hpoint dir_vector){
    String answer = "";
    int num_fix_points = M.fix_points.size();
    int num_added = 0;

    for(int i = 0; i < num_fix_points; i++){
      fix_point temp = (fix_point)M.fix_points.elementAt(i);
      if( num_added < 10) {
	num_added++;
	answer = makepostparams(answer, "x-coord"+num_added,
				Float.toString(temp.x()));
	answer = makepostparams(answer, "y-coord"+num_added,
				Float.toString(temp.y()));
	answer = makepostparams(answer, "z-coord"+num_added,
				Float.toString(temp.z()));
	answer = makepostparams(answer, "i-coord"+num_added,
				Float.toString( M.get_dircos(temp,1)));
	answer = makepostparams(answer, "j-coord"+num_added,
				Float.toString( M.get_dircos(temp,2)));
	answer = makepostparams(answer, "k-coord"+num_added,
				Float.toString( M.get_dircos(temp,3)));
	answer = makepostparams(answer, "check"+num_added, "CHECKED");
	
      }
    }
    
    for(int i = num_added + 1; i <= 10; i ++) {
      num_added++;
      answer = makepostparams(answer, "x-coord"+num_added,
			      "0");
      answer = makepostparams(answer, "y-coord"+num_added,
			      "0");
      answer = makepostparams(answer, "z-coord"+num_added,
			      "0");
      answer = makepostparams(answer, "i-coord"+num_added,
			      "0");
      answer = makepostparams(answer, "j-coord"+num_added,
			      "0");
      answer = makepostparams(answer, "k-coord"+num_added,
			      "0");
    }
    
    
    if(dim) {
      answer = makepostparams(answer,"dimension","3D");
    } else {
      answer = makepostparams(answer,"dimension","planar");
    }
    
    if(type) {
      answer = makepostparams(answer,"type","form-closure");
      answer = makepostparams(answer,"g-dir1","0");
      answer = makepostparams(answer,"g-dir2","1");
      answer = makepostparams(answer,"g-dir3","0");
    } else {
      Float x = new Float(dir_vector.getx());
      Float y = new Float(dir_vector.gety());
      Float z = new Float(dir_vector.getz());
      answer = makepostparams(answer,"type","directional");
      answer = makepostparams(answer,"g-dir1", x.toString());
      answer = makepostparams(answer,"g-dir2", y.toString());
      answer = makepostparams(answer,"g-dir3", z.toString());
    }
    
    return answer;
  }
  
  /**
   * Makes a string of name value pairs in the format accepted by
   * POST method cgi-bin scripts/
   */

  static String makepostparams(String params, String name, String value) {
    
    params = params.concat(name + "=" + value + "&");
    return params;
  }

}


