package RemoteService.resource;

import JavaAgent.resource.*;
import RemoteService.agent.*;

/**
 * Provides a generic interface to a remote service. Specific services will
 * be represented by subclasses of this class. Class files for each Service
 * are obtained by DesignAgents from ServiceAgents. The DesignAgent, after 
 * loading the class file, will instantiate the Service subclass and then
 * call the run() method to execute the service interface.
 * The Service object can communicate, via the DesignAgent, with both other 
 * agents (by using the DA's sendMessage() method) and with
 * service-specific ProD code (by using the DA's send_ProI_message() method).
 *
 * <hr>
 * Copyright (c) 1995, H. Robert Frost, Stanford University.
 * All rights reserved.<p>
 * Copyright (c) 1996, H. Robert Frost, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * <hr>
 * @author <A HREF="http://cdr.stanford.edu/html/people/frost-bio.html"> Rob Frost</A>
 * @version 0.3 5/21/96 for Java(tm) Language Version 1.0.2
 */

public class Service {

  /** 
   * String name for this Service, used as an identifier in messages and
   * in storage Hashtables.
   */
  protected String name;
 
  /**
   * ClientAgent which instantiated this Service object.
   */
  protected ClientAgent parent;

  /**
   * Name of ServiceAgent which supplied the Service class file.
   */
  public static String service_agent;

  /**
   * Creates a new Service object.
   */

  public Service(){
  }

  /*
   * Sets the parameters for the object.
   * @param n Name of Service.
   * @param ca ClientAgent which instantiated the Service.
   */

  public void setParams(String n, ClientAgent ca) {
    parent = ca;
    name = n;
  }

  /**
   * Returns the name of the Service.
   * @return String name of the Service.
   */

  public String getName(){
    return name;
  }

  /**
   * Executes the Service interface. Specific actions must be implemented for
   * each subclass.
    */

  public void run(){
  }

  /**
   * Stops the service.
   */

  public void stop(){
  }

  /**
   * Called when a message is received from the ProIntegrator for this
   * Service object. The message will most likely originate from the
   * Service specific ProD code. Specific actions must be implemented for
   * each subclass.
   * @param message Message content
   * @param sender Message origin
   */
  
  public void message_received(String message, String sender){
  }


  /**
   * Sends a system message to the agent.
   * @param message The system message to output.
   */
  
  public void addSystemMessage(String message){
    parent.addSystemMessage(message);
  }

  /**
   * Sends a system message to the agent w/ exception.
   * @param message The system message to output.
   * @param e Exception which generated the message, may be null.
   */
  
  public void addSystemMessage(String message, Exception e){
    parent.addSystemMessage(message,e);
  }


}
  
  


