package RemoteService.resource;

import java.io.File;

/**
 * Represents a service which has been registered with the ServiceBroker.
 * Available services can be installed via communication with the 
 * respective ServiceAgent.
 *
 * <hr>
 * Copyright (c) 1995, H. Robert Frost, Stanford University.
 * All rights reserved.<p>
 * Copyright (c) 1996, H. Robert Frost, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * <hr>
 * @author <A HREF="http://cdr.stanford.edu/html/people/frost-bio.html"> Rob Frost</A>
 * @version 0.3 5/21/96 for Java(tm) Language Version 1.0.2
 */

public class AvailableService {

  /** 
   * String name for this Service.
   */
  public String name;
 
  /**
   * Name of the ServiceAgent which administers this Service.
   */
  public String agent;

  /**
   * Local gif file which contains a thumbnail representation of the Service.
   */
  public File gif;
  
  /**
   * Local file containing a description of the Service.
   */
  public File descrip;

  /**
   * Name of the class which defines the Service, this field may not be
   * used by some classes.
   */
  public String class_name;

  /**
   * Creates a new AvailableService object.
   */

  public AvailableService(String name){
    this.name = name;
  }

}
  
  


