package RemoteService.context;

import RemoteService.resource.*;
import RemoteService.agent.*;
import JavaAgent.context.*;
import JavaAgent.agent.*;
import JavaAgent.resource.*;

import java.awt.*;
import java.io.File;
import java.util.Vector;

/**
 * Subclass of RSFrame which provides an interface for a ServiceAgent.<p>
 *
 * <hr>
 * Copyright (c) 1995, H. Robert Frost, Stanford University.
 * All rights reserved.<p>
 * Copyright (c) 1996, H. Robert Frost, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * <hr>
 * @author <A HREF="http://cdr.stanford.edu/html/people/frost-bio.html"> Rob Frost</A>
 * @version 0.3 5/21/96 for Java(tm) Language Version 1.0.2
 */

public class ServiceFrame extends RSFrame {
  
  protected Menu Service = new Menu("Service",true);
  protected MenuItem AddService = 
    new MenuItem("Add Service");
  protected MenuItem RemoveService = 
    new MenuItem("Remove Service");
  protected AddServicePanel asp = null;

  /**
   * Constructor for an ServiceFrame. Creates GUI components.
   * @param context AgentContext which created this gui.
   * @param title Title for the frame.
   */

  public ServiceFrame(AgentContext context, String title){
    super(context,title);
  
    Controls.add(Service);
    Service.add(AddService);
    Service.add(RemoveService);
  }

  /**
   * Called when an event happens in the ServiceFrame. Used to take action
   * on menu bar selections.
   *
   * @param evt The event which triggered the method call.
   * @param arg Who called the method. For buttons, string name of button.
   */

  public boolean action(Event evt, Object arg) {
  
    if(evt.target instanceof MenuItem){
      MenuItem selected = (MenuItem)evt.target;
      if(selected.equals(AddService)){
	AddServiceAction();
      } else if(selected.equals(RemoveService)){
	RemoveServiceAction();
      }
    }
    
    return super.action(evt,arg);
  }

  /**
   * Terminates all of the panels.
   */

  protected void terminatePanels(){
    terminatePanel(asp);
    super.terminatePanels();
  }
  
  /**
   * Adds a Service.
   */

  void AddServiceAction(){
    asp = new AddServicePanel(this);
    CreateNewFrame(asp,RSContextParams.ASP_WIDTH,
		   RSContextParams.ASP_HEIGHT,"Add Service");
  }

  /**
   * Adds the Service to the list of Services managed by the ServiceAgent. 
   * Assumes that the gif and descrip files are in the shared directory with
   * the service's name terminated by either .gif or .descrip.
   * @param name Name of the Service
   * @param class_name Full name of the class which represents the Service.
   */

  void newService(String name, String class_name){
      AvailableService service = new AvailableService(name);
      service.class_name = class_name;
      service.gif = new File(getAgent().getSharedDir(), "files" +
			     File.separator + name + ".gif");
      service.descrip = new File(getAgent().getSharedDir(), "files" +
			     File.separator + name + ".descrip");
      ((ServiceAgent)getAgent()).addService(service);
  } 

  /**
   * Called to remove a service.
   * @param service_name Name of the service.
   */
  
  public void RemoveServiceAction(){
    /* get the selected icon */
    if(pb.selected_index >= 0){
      /* send out the unregister-service message */
      ((ServiceAgent)getAgent()).removeService((String)names.elementAt(pb.selected_index));
    } else {
      addSystemMessage("No Service selected for removal!");
    }
  }

}



















