package RemoteService.context;

import RemoteService.agent.*;
import RemoteService.resource.*;
import JavaAgent.context.*;
import JavaAgent.agent.*;
import JavaAgent.resource.*;
import java.io.*;
import java.net.*;
import java.util.*;

/**
 * Subclass of SocketContext which contains a ServiceAgent.<p>
 *
 * <hr>
 * Copyright (c) 1995, H. Robert Frost, Stanford University.
 * All rights reserved.<p>
 * Copyright (c) 1996, H. Robert Frost, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * <hr>
 * @author <A HREF="http://cdr.stanford.edu/html/people/frost-bio.html"> Rob Frost</A>
 * @version 0.3 5/21/96 for Java(tm) Language Version 1.0.2
 */

public class ServiceContext extends SocketContext {

  /**
   * ServiceContext constructor.
   */

  public ServiceContext(SocketParams params){
    super(params);
  }

  /**
   * If the gui flag is set, creates a SocketFram.e
   */

  protected void createGUI(){
    if(params.gui){
      frame = new ServiceFrame(this,params.name);
      frame.resize(RSContextParams.RSF_WIDTH, 
		   RSContextParams.RSF_HEIGHT);
      frame.show();
    } 	
  }

  /**
   * Creates the ServiceAgent object.
   */  

  protected boolean addAgent(){
    if(params.init_url != null){
      A = new ServiceAgent(this,(params.name != null)?params.name:"ServiceAgent",
			   params.init_url, params.shared_url, 
			   params.shared_dir, params.working_dir);
      A.init();
      return true;
    } else {
      addSystemMessage("Do not have location of initialization file!");
    }
    return false;
  }
  
  /**
   * Called if the ServiceContext is started as an application from the command
   * line. Command line args:<p><ul>
   * <li> -i init_file URL
   * <li> [-s] shared classes URL, for classes and other files which will
   * be shared with other agents.
   * <li> [-l] local directory for writing to the shared classes URL.
   * <li> [-w] working directory for saving local files, this should not
   * be included if the agent cannot access the local disk 
   * <li> [-n] name, only included if the Agent should automatically 
   * connect to the network.
   * <li> [-gui] create a GUI if this flag is included
   * <li> [-p] For for ServerSocket
   * </ul>
   * @param arg Array of command line arguments.
   */

  public static void main(String arg[]) {
    Hashtable args = AgentContext.parseArgs(arg);
    ServiceContext sc = new ServiceContext(new SocketParams(args));
  }

}



















