package RemoteService.context;

import JavaAgent.context.SocketParams;
import java.io.File;
import java.net.URL;
import java.util.Hashtable;

/**
 * Subclass of SocketParams which holds runtime parameters for a 
 * ClientContext.<p>
 *
 * <hr>
 * Copyright (c) 1995, H. Robert Frost, Stanford University.
 * All rights reserved.<p>
 * Copyright (c) 1996, H. Robert Frost, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * <hr>
 * @author <A HREF="http://cdr.stanford.edu/html/people/frost-bio.html"> Rob Frost</A>
 * @version 0.3 5/21/96 for Java(tm) Language Version 1.0.2
 */


public class ClientParams extends SocketParams{

  /**
   * Process id for process connected to stdout.
   */
  public String pid;
  
  /**
   * Signal number to use for interrupting the local process.
   */
  public String sig;

  /**
   * Is local comm enabled?
   */
  public boolean localcomm = false;

  /**
   * Constructor for use with applets 
   */
  public ClientParams(){}
  
  /**
   * Constructor the ClientParams object. Takes a Hashtable containing 
   * parameter values as input.
   */
  
  public ClientParams(Hashtable args){
    super(args);
    if(args.containsKey("-comm")){
      localcomm = true;
    } 
    if(args.containsKey("-pid")){
      pid = (String)args.get("-pid");
    } 
    if(args.containsKey("-sig")){
      sig = (String)args.get("-sig");
    } 
  }

}
