package RemoteService.context;

import RemoteService.agent.*;
import JavaAgent.context.*;
import JavaAgent.agent.*;
import JavaAgent.resource.*;

import java.awt.*;
import java.util.Vector;

/**
 * Subclass of RSFrame which provides an interface for a ClientAgent.<p>
 *
 * <hr>
 * Copyright (c) 1995, H. Robert Frost, Stanford University.
 * All rights reserved.<p>
 * Copyright (c) 1996, H. Robert Frost, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * <hr>
 * @author <A HREF="http://cdr.stanford.edu/html/people/frost-bio.html"> Rob Frost</A>
 * @version 0.3 5/21/96 for Java(tm) Language Version 1.0.2
 */

public class ClientFrame extends RSFrame {
  
  protected Menu Client = new Menu("Client",true);
  protected MenuItem GetAvailable = 
    new MenuItem("Get Available Services");

  /**
   * Constructor for an ClientFrame. Creates GUI components.
   * @param context AgentContext which created this gui.
   * @param title Title for the frame.
   */

  public ClientFrame(AgentContext context, String title){
    super(context,title);
    Controls.add(Client);
    Client.add(GetAvailable);
  }

  /**
   * Called when an event happens in the ClientFrame. Used to take action
   * on menu bar selections.
   *
   * @param evt The event which triggered the method call.
   * @param arg Who called the method. For buttons, string name of button.
   */

  public boolean action(Event evt, Object arg) {
  
    if(evt.target instanceof MenuItem){
      MenuItem selected = (MenuItem)evt.target;
      if(selected.equals(GetAvailable)){
	GetAvailableAction();
      }
    }
    
    return super.action(evt,arg);
  }

  /**
   * Sends a message to the ServiceBroker requesting a list of currently
   * available services.
   */

  protected void GetAvailableAction(){
    ((ClientAgent)getAgent()).getAvailable();
  }

  /**
   * Called when one of the Service icons is double-clicked, must be
   * overridden.
   * @param index Index of the selected icon.
   */

  protected void doubleClickAction(int index){
    ((ClientAgent)getAgent()).executeService((String)names.elementAt(index));
  }

}



















