package RemoteService.context;

import JavaAgent.context.*;
import java.awt.*;
import java.util.Enumeration;
import java.util.Hashtable;
import java.net.URL;

/**
 * Panel opened by a ServiceFrame which allows the user to add a Service to the
 * group of services managed by a ServiceAgent.<p>
 *
 * <hr>
 * Copyright (c) 1995, H. Robert Frost, Stanford University.
 * All rights reserved.<p>
 * Copyright (c) 1996, H. Robert Frost, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * <hr>
 * @author <A HREF="http://cdr.stanford.edu/html/people/frost-bio.html"> Rob Frost</A>
 * @version 0.3 5/21/96 for Java(tm) Language Version 1.0.2
 */

public class AddServicePanel extends InterfacePanel {
  
  protected Label NameLabel = new Label("Service Name:");
  protected TextField ServiceName = new TextField();
  protected Label ClassLabel = new Label("Service Class:");
  protected TextField ServiceClass = new TextField();
  protected Button AddService = new Button("Add");
  protected Button Cancel = new Button("Cancel");

  /**
   * Creates an AddServicePanel for an object which implements the 
   * AgentContext Interface.
   * @param context The object for which the panel is created.
   */

  public AddServicePanel(AgentFrame frame) {    
    super(frame);
    setLayout(new GridLayout(3,2));
    add(NameLabel);
    add(ServiceName);
    add(ClassLabel);
    add(ServiceClass);
    add(AddService);
    add(Cancel);
  }

  /**
   * Called when an event happens. Currently used to identify
   * when buttons are pushed.
   * @param evt The event which triggered the method call.
   * @param arg Who called the method. For buttons, string name of button.
   */
  
  public boolean action(Event evt, Object arg) {
    if("Add".equals(arg)) {
      addServicesAction();
    } else if("Cancel".equals(arg)) {
      terminate();
    } 
    
    return true;
  }
  
  /**
   * Adds the specified service.
   */

  private void addServicesAction(){
    String name = ServiceName.getText();
    String class_name = ServiceClass.getText();
    if(name.length() > 0 && class_name.length() > 0){
      ((ServiceFrame)parent).newService(name,class_name );
      ServiceName.setText("");
      ServiceClass.setText("");
    }
  }
  
}














