package RemoteService.agent;

import JavaAgent.agent.*;
import JavaAgent.resource.*;
import RemoteService.resource.*;

import java.util.Hashtable;
import java.util.Vector;
import java.util.Enumeration;


/**
 * Subclass of MessageHandler which handles all message transmissions for a
 * ServiceAgent.<p>
 *
 * <hr>
 * Copyright (c) 1995, H. Robert Frost, Stanford University.
 * All rights reserved.<p>
 * Copyright (c) 1996, H. Robert Frost, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * <hr>
 * @author <A HREF="http://cdr.stanford.edu/html/people/frost-bio.html"> Rob Frost</A>
 * @version 0.3 5/21/96 for Java(tm) Language Version 1.0.2
 */

public class ServiceMessageHandler extends MessageHandler {

  /**
   * Creates a new ServiceMessageHandler.
   * @param parent ServiceAgent which this handler represents.
   */

  public ServiceMessageHandler(ServiceAgent parent){
   super(parent);
  } 

  /**
   * Called when the executable class which contains the ServiceAgent 
   * terminates, first unregisters all of the services, then
   * sends a remove-address message to the ANS.
   */
  
  public void initiateTermination(){
    unregisterServices();
    super.initiateTermination();
  }

  private void unregisterServices(){
    Enumeration e = 
      parent.getResource("available_service").getElements();
    while(e.hasMoreElements()){
      String message = "(evaluate :receiver ANS :ontology service " +
	":language KQML " +
	  ":sender " + parent.getName() + " :content (unregister-service" +
	    " :name " + (String)e.nextElement() + "))";
      sendMessage(new KQMLmessage(message));
    }

  }
  
}



