package RemoteService.agent;

import RemoteService.resource.*;

import JavaAgent.agent.*;
import JavaAgent.resource.*;

import java.util.Hashtable;
import java.util.Vector;
import java.util.Enumeration;
import java.io.*;
import java.net.URL;
import java.awt.Panel;

/**
 * Manages all of the Resource objects for a specific ServiceBroker.<p>
 *
 * <hr>
 * Copyright (c) 1995, H. Robert Frost, Stanford University.
 * All rights reserved.<p>
 * Copyright (c) 1996, H. Robert Frost, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * <hr>
 * @author <A HREF="http://cdr.stanford.edu/html/people/frost-bio.html"> Rob Frost</A>
 * @version 0.3 5/21/96 for Java(tm) Language Version 1.0.2
 */

public class BrokerResourceManager extends ResourceManager{

  /**
   * Services available for installation. Elements are sublclasses
   * of AvailableService.
   */

  protected AvailableServices available_services;

  /**
   * Initializes the memory and contents of all Agent resources.
   */

  public BrokerResourceManager(ServiceBroker parent){
    super(parent);
    available_services = new AvailableServices(parent);
    interpreters.addElement("service", new ServiceInterpreter(), true);
  }

  /**
   * Get the resource object for the specified type.
   * @param type Resource type to get, one of: "address", "language",
   * "interpreter", "class" or "available_service".
   * @return Resource object or null if type does not exist.
   */

  public Resource getResource(String type){  
    if(type.equals("available_service")){
      return available_services;
    } 
    return super.getResource(type);
  }

}
