package RemoteService.agent;

import JavaAgent.agent.*;
import JavaAgent.resource.*;
import RemoteService.resource.*;

import java.util.Hashtable;
import java.util.Vector;
import java.util.Enumeration;


/**
 * Subclass of ANSMessageHandler which handles all message transmissions for a
 * ServiceBroker.<p>
 *
 * <hr>
 * Copyright (c) 1995, H. Robert Frost, Stanford University.
 * All rights reserved.<p>
 * Copyright (c) 1996, H. Robert Frost, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * <hr>
 * @author <A HREF="http://cdr.stanford.edu/html/people/frost-bio.html"> Rob Frost</A>
 * @version 0.3 5/21/96 for Java(tm) Language Version 1.0.2
 */

public class BrokerMessageHandler extends ANSMessageHandler {

  /**
   * Creates a new BrokerMessageHandler.
   * @param parent ServiceBroker which this handler represents.
   */

  public BrokerMessageHandler(ServiceBroker parent){
   super(parent);
  } 

  /**
   * Send unregister-service messages to all of the agents in the clients 
   * buffer. Called whenever the ServiceBroker receives an unregister-service
   * message from a ServiceAgent.
   * @param name Service name which is being unregistered.
   * @param service_agent Name of the ServiceAgent which administered the 
   * Service.
   */

  public void SendUnregisterMessage(String name, String service_agent){
    Enumeration agents = ((ServiceBroker)parent).getClients();
    String message = "(evaluate :ontology service :language KQML " +
      ":sender ANS :content (unregister-service :name " + name + "))";
   
    if(agents.hasMoreElements()){
      while(agents.hasMoreElements()){
	KQMLmessage kmessage = new KQMLmessage(message);
	String agent_name = (String)agents.nextElement();
	if(!agent_name.equals("ANS") && !agent_name.equals(service_agent)){
	  kmessage.addFieldValuePair("receiver",agent_name);	  
	  sendMessage(kmessage);        
	}
      }
    }
  }
 
}



