package Planning;

import JavaAgent.resource.fopl.Substitution;
import JavaAgent.resource.fopl.Literal;

import java.io.*;
import java.util.*;

public class Operator {

  public Operator(Vector vars, Vector precs, Vector effects) {
    theVars = vars;
    thePrecs = precs;
    theEffects = effects;
  }

  public Object clone() {
    Operator res = new Operator(new Vector(), new Vector(), new Vector());
    Substitution s = new Substitution();
    for (Enumeration ve=theVars.elements(); ve.hasMoreElements(); )
      res.theVars.addElement(((JavaAgent.resource.fopl.VarTerm)s.
          getValue((JavaAgent.resource.fopl.Variable)ve.nextElement())).
          getVar());
    for (Enumeration pe=thePrecs.elements(); pe.hasMoreElements(); )
      res.thePrecs.addElement(((Literal)pe.nextElement()).clone(s));
    for (Enumeration ee=theEffects.elements(); ee.hasMoreElements(); )
      res.theEffects.addElement(((Literal)ee.nextElement()).clone(s));
    return res;
  }

  public Vector getPreconditions() {
    return thePrecs;
  }

  public Vector getEffects() {
    return theEffects;
  }

  public String toString() {
    return "(op " + theVars + " :preconds " + thePrecs + 
        " :effects " + theEffects + ')';
  }

  private Vector theVars, thePrecs, theEffects;

}
