delim		[ \t\n]
ws		{delim}+
digit		[0-9]
integer		[+\-]?{digit}+
purefloat	([+\-]?{digit}*(\.{digit}+))|([+\-]?{digit}+(\.{digit}*))
exp             ((E|e)[+\-]?{digit}+)
real		({purefloat}{exp}?)|({integer}{exp})
string		\"([^"\\]|(\\.))*\"
constant	[^ )(\t\n]+
variable	\?{constant}
seqvar		\@{constant}

%%

{ws}			    /* no action */
"("			    { yyreturn('('); }
")"			    { yyreturn(')'); }
"="			    { yyreturn('='); }
("term"|"TERM")             { yyreturn(TERM); }
("literal"|"LITERAL")       { yyreturn(LITERAL); }
("formula"|"FORMULA")       { yyreturn(FORMULA); }
("forms"|"FORMS")           { yyreturn(FORMS); }
("clause"|"CLAUSE")         { yyreturn(CLAUSE); }
("clauseset"|"CLAUSESET")   { yyreturn(CLAUSESET); }
("list"|"LIST")             { yyreturn(LIST); }
("forall"|"FORALL")	    { yyreturn(FORALL); }
("exists"|"EXISTS")	    { yyreturn(EXISTS); }
("or"|"OR")		    { yyreturn(OR); }
("and"|"AND")		    { yyreturn(AND); }
("implies"|"IMPLIES"|"=>")  { yyreturn(IMPLIES); }
("iff"|"IFF"|"<=>")	    { yyreturn(IFF); }
("xor"|"XOR")		    { yyreturn(XOR); }
("not"|"NOT")		    { yyreturn(NOT); }
{variable}                  { yyreturn(VARIABLE); }
{constant}		    { yyreturn(CONSTANT); }

%%

@TOKENTYPES@
