package JavaAgent.resource.fopl;


import java.util.*;


/** 
 ** This class extends the Symbol class to allow for the creation of unnamed 
 ** Symbols as used, for example, in Skolemization.
 */

public class UnnamedSymbol extends Symbol {

  /**
  ** An UnnamedSymbol can be constructed with a name that will characterize 
  ** the type of this Symbol. A new, unique index is generated automatically.
  ** @param name the type of this symbol, e.g. <tt>"SkolemConst"</tt>
  ** @exception IllegalArgumentException An exception will occur if the 
  ** supplied String is empty or null.
  ** @exception OutOfMemoryError An error can occur if the unique indices for 
  ** UnnamedSymbols have run out.
  */
  public UnnamedSymbol(String name) throws IllegalArgumentException {
    super(name);
    index = skIndex++;
    if (skIndex == Integer.MAX_VALUE)
      throw new OutOfMemoryError("UnnamedSymbol index overflow!");
  }

  /**
  ** This protected constructor creates an unnamed symbol. Its type which 
  ** will be used in printing the UnnamedSymbol will be 
  ** <tt>UnnamedSymbol</tt>. Normally the public constructor above should 
  ** be used.
  ** @exception OutOfMemoryError An error can occur if the unique indices for 
  ** UnnamedSymbols have run out.
  */
  protected UnnamedSymbol() {
    super("UnnamedSymbol");
    index = skIndex++;
    if (skIndex == Integer.MAX_VALUE)
      throw new OutOfMemoryError("UnnamedSymbol index overflow!");
  }
    
  /** 
  ** An UnnamedSymbol is printed as its name and the unique index.
  ** @return the type and index, e.g. <tt>SkolemConst_15</tt>
  */
  public String toString() {
    return theName + '_' + index;
  }

  private int index;

  private static int skIndex = 0;
}
