package JavaAgent.resource.cdl;


/**
** A Parsable is any Object that can be parsed by a Parser. That is,
** given a String, there is a way of constructing an Object that is a 
** (implements) Parsable.
** <p> There are two possible ways this functionality can be achieved:
** <ul>
** <li> <b>constructor</b>: There might be a constructor that takes exactly
** one argument which must be an instance of class String. This can only be
** defined if the class implementing Parsable is not abstract.
** <li> <b>static function</b>: There might be a static function defined as 
** "<tt>static Parsable parse(String s);</tt>" which parses the given String 
** and returns the created Object.
** </ul>
** <p> Alternatively, it might be possible to parse Objects from an 
** InputStream instead of a String. Classes that implement Parsable should 
** provide at least one of these methods. Unfortunately it does not seem 
** possible to enforce such an interface with Java's inheritance mechanism. 
*/

public interface Parsable {
  /**
  ** This function converts the Parsable into a String that if parsed again
  ** results in another Parsable of the same type that is equivalent to the 
  ** original Parsable.
  */
  public String toString();
}
