package JavaAgent.resource.cdl;


/**
** A KRSentence is a sentence in some formal knowledge representation 
** language. Inheriting from this interface does not demand much from
** the inheriting class, but there are a number of functions that, if
** implemented should be declared as follows:
** <ul>
** <li> <b>public FOPLFormula getFOPLFormula();</b>
**   <br> This function should return a FOPLFormula that represents
**   this KRSentence. Remark: A more elegant approach would use KIF
**   as an interlingua at this point.
** <li> <b>public ClauseSet getClauses();</b>
**   <br> This function should return a ClauseSet that represents
**   this KRSentence. Remark: A more elegant approach would use KIF
**   as an interlingua at this point.
** <li> <b>static public KRSentence getConjunction(Vector);</b>
**   <br> This function should return a KRSentence that represents the
**   conjunction of the KRSentences in the given Vector of KRSentences.
** <li> <b>static public KRSentence getDisjunction(Vector);</b>
**   <br> This function should return a KRSentence that represents the
**   disjunction of the KRSentences in the given Vector of KRSentences.
** <li> <b>static public Class getKBClass();</b>
**   <br> This function should return the Class that implements a
**   KnowledgeBase for this KRSentence.
** </ul>
*/

public interface KRSentence {
  /**
  ** This function generates a copy of this KRSentence that holds the same
  ** knowledge in the same formalism.
  */
  public Object clone();

  /**
  ** This function generates a String that is the printable version of this 
  ** KRSentence.
  */
  public String toString();
}
