package JavaAgent.resource;

/**
 * Represents the address of an Agent which communicates via a SocketInterface.
 * Address is represented by a host and port.
 *
 * <hr>
 * Copyright (c) 1995, H. Robert Frost, Stanford University.
 * All rights reserved.<p>
 * Copyright (c) 1996, H. Robert Frost, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * <hr>
 * @author <A HREF="http://cdr.stanford.edu/html/people/frost-bio.html"> Rob Frost</A>
 * @version 0.3 5/21/96 for Java(tm) Language Version 1.0.2
 */

public class SocketAddress extends AgentAddress {

  /**
   * Internet host name, forms the host portion of a url. This will either
   * be a human readable string or an IPaddress.
   * Example: "piano.stanford.edu".
   */
  public String host = null;

  /**
   * Port on the host machine. The Agent having this address will have a 
   * ServerSocket bound to this port.
   */
  public int port;

  /**
   * Creates a new SocketAddress with the specified host and port.
   * @param h Address host. Full host name, e.g. piano.stanford.edu, or
   * IPaddress.
   * @param p Local port number.
   */
  public SocketAddress(String h, int p){
    host = h;
    port = p;
  }

  /**
   * Gets a String representation of the value of the address, used
   * for sending messages about addresses.
   * @return String value.
   */
  public String getValue(){
    return (host + ":" + port);
  }

  /**
   * Returns value of address as string for display.
   * @return address value
   */

  public String toString(){
    return("host: " + host + " port: " + port);
  }

}
