package JavaAgent.resource;

/**
 * Abstract class which defines the syntax of a finite length string passed
 * between Agents in a message. This string represents a non-proper subset of
 * the total message. (Thus, it could be the entire message or only a portion
 * of the message). Each subclass of Language must have a constructor which 
 * takes a String as input and parses the string to construct the Message
 * object.<p>
 *
 * <hr>
 * Copyright (c) 1995, H. Robert Frost, Stanford University.
 * All rights reserved.<p>
 * Copyright (c) 1996, H. Robert Frost, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * <hr>
 * @author <A HREF="http://cdr.stanford.edu/html/people/frost-bio.html"> Rob Frost</A>
 * @version 0.3 5/21/96 for Java(tm) Language Version 1.0.2
 */

public class Language {
  
  /**
   * Creates an empty Language instance.
   */

  public Language(){
  }
    
  /**
   * Creates a Language instance by parsing the input String.
   *
   * @param input The string to be parsed.
   */

  public Language(String input){
    this();
    parseString(input);
  }

  /**
   * Takes an empty Language instance and populates it by parsing
   * an input string.
   *
   * @param input The string to be parsed.
   */

  public void parseString(String input){
   
  }

  
}

