package JavaAgent.resource;

import JavaAgent.agent.Agent;

/**
 * Abstract superclass of all interpreters which define the semantic binding for 
 * message content. Each subclass of Interpreter must at a minimum implement a 
 * method interpretMessage(), which takes an instance of object Language as
 * an argument.<p>
 *
 * <hr>
 * Copyright (c) 1995, H. Robert Frost, Stanford University.
 * All rights reserved.<p>
 * Copyright (c) 1996, H. Robert Frost, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * <hr>
 * @author <A HREF="http://cdr.stanford.edu/html/people/frost-bio.html"> Rob Frost</A>
 * @version 0.3 5/21/96 for Java(tm) Language Version 1.0.2
 */

public class Interpreter {
  
  /**
   * Creates a new instance of Interpreter.
   */
  
  public Interpreter(){ }
  
  /**
   * Interpret a given message according to the semantics of the
   * of the Interpreter. If the language type cannot be interpreted according to
   * the Interpreter a InterpretationException is thrown.
   *
   * @param message Message which needs to be interpreted.
   * @param receiver Agent who received the message.
   */
  
  public void interpretMessage(KQMLmessage message, Agent receiver) throws
    InterpretationException {
      
      String lang = message.getValue("language");
      Class c = null;

      try {
	c = (Class)receiver.getResource("language").
	  getElement(lang, RetrievalResource.SEND_MSG);
      } catch (ResourceException e){
	receiver.getResource("language").removeElement(lang);
	throw new InterpretationException("Language " + lang +
					  " not known.");
      }

      try{
	Object obj = c.newInstance();
	Language language = (Language)obj;
	language.parseString(message.getValue("content"));
	interpretLanguage(message, receiver, language);
      } catch (InstantiationException e){
	throw new InterpretationException("Error instantiating " + lang + 
					  "object, " + e.toString());
      }  catch (IllegalAccessException e){
	throw new InterpretationException("Error instantiating " + lang + 
					  "object, " + e.toString());
      }
    }

  /**
   * Interpret the Language instance, from the message, for the reciever
   * according to the present Interpreter.
   *
   * @param message Message which needs to be interpreted.
   * @param receiver Agent who received the message.
   * @param language Instance of Language which represents the message
   * contents.
   */

  protected void interpretLanguage(KQMLmessage message, Agent receiver,
			 Language language) throws InterpretationException{
			 }
  
  /**
   * Is the named class in the reflexive, transitive closure of the object's 
   * superclasses?
   * @param c Class being tested.
   * @param compared Name of which is being matched.
   * @return boolean indicating superclass match.
   */
  
  public static boolean isSuper(Class c, String compared){
    if(c.getName().equals(compared)){
      return true;
    } else if(!c.getName().equals("java.lang.Object")){
      return isSuper(c.getSuperclass(),compared);
    } 
    return false;
  }
  
}


