package JavaAgent.resource;

import java.net.URL;

/**
 * Represents the location of a file resource (language, Interpreter or class).
 *
 * <hr>
 * Copyright (c) 1995, H. Robert Frost, Stanford University.
 * All rights reserved.<p>
 * Copyright (c) 1996, H. Robert Frost, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * <hr>
 * @author <A HREF="http://cdr.stanford.edu/html/people/frost-bio.html"> Rob Frost</A>
 * @version 0.3 5/21/96 for Java(tm) Language Version 1.0.2
 */

public class FileLocation {

  protected URL file_base;
  protected String object_name;

  /**
   * Constructor for FileLocation
   *
   * @param file_base URL for file base 
   * @param object_name Full name of the object
   */

  public FileLocation(URL file_base, String object_name){
    this.file_base = file_base;
    this.object_name = object_name;
  }

  /** 
   * Gets the base URL.
   * @return base URL for the file. 
   */
  
  public URL getFileBase(){
    return file_base;
  }

  /** 
   * Gets the object name
   * @return Name of the object
   */
  
  public String getObjectName(){
    return object_name;
  }

  /**
   * Returns String representation of the file location.
   */
    
  public String toString(){
    return ("URL: " + file_base.toString() + "\n" +
	    "Object: " + object_name);
  }

}


  







