package JavaAgent.oplan;

import java.net.URL;
import java.util.Hashtable;

import JavaAgent.resource.SocketAddress;

/**
** This class extends SocketParams to allow for one additional parameter to 
** be dealt with, the address of the broker. This parameter must be 
** supplied to an OPAgentContext.
** @see OPAgentContext
*/

public class OPSocketParams extends JavaAgent.context.SocketParams {

  /**
  ** The constructor calls the constructor for SocketParams and 
  ** extracts the broker address from the given HashTable.
  ** @param args the command line arguments
  */
  public OPSocketParams(Hashtable args) {
    super(args);
    String bStr = (String)args.get("-b");
    String host = bStr.substring(0,bStr.indexOf(":"));
    String port_str = bStr.substring(bStr.indexOf(":")+1);
    Integer port = new Integer(port_str);
    brokerAddr = new SocketAddress(host, port.intValue());
  }

  /**
  ** This function gets the SocketAddress of the broker.
  ** @return the SocketAddress of the broker (ANS)
  */
  public SocketAddress getBrokerAddress() {
    return brokerAddr;
  }

  /**
  ** This variable contains the address of the broker
  */
  protected SocketAddress brokerAddr;

}
