package JavaAgent.context;

import JavaAgent.resource.*;
import java.awt.*;
import java.util.*;

/**
 * Panel which allows a user to view the Resource elements possessed
 * by an Agent.<p>
 *
 * <hr>
 * Copyright (c) 1995, H. Robert Frost, Stanford University.
 * All rights reserved.<p>
 * Copyright (c) 1996, H. Robert Frost, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * <hr>
 * @author <A HREF="http://cdr.stanford.edu/html/people/frost-bio.html"> Rob Frost</A>
 * @version 0.3 5/21/96 for Java(tm) Language Version 1.0.2
 */

public class ViewResourcePanel extends InterfacePanel {
  
  protected Choice ResourceSelect = new Choice();
  protected Button Done = new Button("Done");
  protected TextArea ResourceDisplay = new TextArea(15, 30);
  protected String current_resource = "address";

  /**
   * Creates a ViewResourcePanel for subclass of AgentFrame.
   * @param frame The object for which the panel is created.
   */

  protected ViewResourcePanel(AgentFrame frame) {
   
    super(frame);
    
    setLayout(new BorderLayout());
    
    add("North", ResourceSelect);
    add("Center", ResourceDisplay);
    add("South", Done);
    
    ResourceSelect.addItem("Addresses");
    ResourceSelect.addItem("Languages");
    ResourceSelect.addItem("Interpreters");
    ResourceSelect.addItem("Classes");
    ResourceSelect.addItem("Files");
    ResourceSelect.select("Addresses");

    showResource();    
  }

  /**
   * Called when a displayed resource has changed.
   */

  protected void resourceChanged(String type){
    if(type.equals(current_resource)){
      showResource();
    }
  }

  /**
   * Show the currently selected resource.
   */

  protected void showResource() {
    Enumeration names;

    if(current_resource != null){
      Resource r = parent.getAgent().getResource(current_resource);
      names = r.getElements();

      String display = "";
      
      while(names.hasMoreElements()) {
	try{
	  String name = (String)names.nextElement();
	  display = display.concat("Name: " + name + "\n");
	  display = 
	    display.concat("Value: " + 
			   r.getElement(name,Resource.NO_RETRIEVAL).toString() + "\n");
	  Object location = r.getLocation(name);
	  if(location != null){
	    display = display.concat("Location:\n " + location.toString() +
				     "\n");
	  }
	
	  display = display.concat("\n");
	} catch(ResourceException e){}
      } 
      ResourceDisplay.setText(display);   
    }
    
  }
  
  /**
   * Called when an event happens. Currently used to identify
   * when buttons are pushed.
   * @param evt The event which triggered the method call.
   * @param arg Who called the method. For buttons, string name of button.
   */
  
  public boolean action(Event evt, Object arg) {
    if("Done".equals(arg)) {
      terminate();
    } else if(evt.target instanceof Choice){
      String type = ResourceSelect.getSelectedItem();
      if(type.equals("Addresses")){
	current_resource = "address";
      } else if(type.equals("Languages")){
	current_resource = "language";
      } else if(type.equals("Interpreters")){
	current_resource = "interpreter";
      } else if(type.equals("Classes")){
	current_resource = "class";
      } else if(type.equals("Files")){
	current_resource = "file";
      }
      showResource();
    } 
    return true;
  }
  
}





