package JavaAgent.context;

import JavaAgent.resource.KQMLmessage;

import java.awt.*;
import java.util.*;

/**
 * Panel which allows a user to view sent and received KQMLmessages.<p>
 *
 * <hr>
 * Copyright (c) 1995, H. Robert Frost, Stanford University.
 * All rights reserved.<p>
 * Copyright (c) 1996, H. Robert Frost, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * <hr>
 * @author <A HREF="http://cdr.stanford.edu/html/people/frost-bio.html"> Rob Frost</A>
 * @version 0.3 5/21/96 for Java(tm) Language Version 1.0.2
 */

public class ViewMessagePanel extends InterfacePanel {
 
  protected int current_msg;
  protected int total_msg;

  protected Vector messages_in;
  protected Vector messages_out;
  protected Vector displayed_messages;

  protected Panel TopPanel = new Panel();
  protected Panel ButtonPanel = new Panel();
  protected Panel ContentPanel = new Panel();

  protected Choice MessageSelect = new Choice();
  protected Label CurrentMsgLabel =  new Label("Message #:");
  protected Label CurrentMsg =  new Label("1");
  protected Label TotalMsgLabel =  new Label("Total # Messages:");
  protected Label TotalMsg =  new Label("1");
  protected Button UpMsg = new Button("Up Message");
  protected Button DownMsg = new Button("Down Message");
  protected Label PerformativeLabel = new Label("Performative:");
  protected TextField Performative = new TextField(20);
  protected Label SenderLabel = new Label("Sender:");
  protected TextField Sender = new TextField(20);
  protected Label ReceiverLabel = new Label("Receiver:");
  protected TextField Receiver = new TextField(20);
  protected Label LanguageLabel = new Label("Language:");
  protected TextField Language = new TextField(20);
  protected Label InterpreterLabel = new Label("Interpreter:");
  protected TextField Interpreter = new TextField(20);
  protected Label ContentLabel = new Label("Content:");
  protected TextArea Content = new TextArea();
  protected Button Done = new Button("Done");
  
  /**
   * Creates a ViewMessagePanel for a subclass of AgentFrame.
   * @param frame AgentFrame for which the panel is created.
   */

  public ViewMessagePanel(AgentFrame frame) {
    super(frame);

    setLayout(new BorderLayout());
    add("North",TopPanel);
    add("Center",ContentPanel);
    
    MessageSelect.addItem("Received Messages");
    MessageSelect.addItem("Transmitted Messages");
    MessageSelect.select("Received Messages");

    TopPanel.setLayout(new BorderLayout(horiz_spacing,vert_spacing));      
    TopPanel.add("North", MessageSelect);
    TopPanel.add("Center",ButtonPanel);
    ButtonPanel.setLayout(new GridLayout(8,2, horiz_spacing, vert_spacing));
    ContentPanel.setLayout(new BorderLayout());      

    ButtonPanel.add(UpMsg);
    ButtonPanel.add(DownMsg);
    ButtonPanel.add(TotalMsgLabel);
    ButtonPanel.add(TotalMsg);
    ButtonPanel.add(CurrentMsgLabel);
    ButtonPanel.add(CurrentMsg);
    ButtonPanel.add(PerformativeLabel);
    ButtonPanel.add(Performative);
    ButtonPanel.add(SenderLabel);
    ButtonPanel.add(Sender);
    ButtonPanel.add(ReceiverLabel);
    ButtonPanel.add(Receiver);
    ButtonPanel.add(LanguageLabel); 
    ButtonPanel.add(Language);
    ButtonPanel.add(InterpreterLabel); 
    ButtonPanel.add(Interpreter);
    ContentPanel.add("North",ContentLabel); 
    ContentPanel.add("Center",Content);
    ContentPanel.add("South",Done);

    resourceChanged("message");
  }

  /**
   * Called when either a message has arrived or one has been sent.
   * @type Type of the resource which changed. Should be message.
   */

  protected void resourceChanged(String type){
    messages_in = parent.getAgent().getReceivedMessages();
    messages_out = parent.getAgent().getSentMessages();
    switchBuffers();
  }

  /**
   * Switches between message buffers.
   */

  void switchBuffers(){
    String type = MessageSelect.getSelectedItem();

    if(type.equals("Received Messages")){
      if(messages_in.size() > 0){
	current_msg = messages_in.size();
	displayed_messages = messages_in;
      } else {
	MessageSelect.select("Transmitted messages");
      }
    } else if(type.equals("Transmitted Messages")){
      if(messages_out.size() > 0){
	current_msg = messages_out.size();
	displayed_messages = messages_out;	
      } else {
	MessageSelect.select("Received Messages");
      }      
    }   
    total_msg = current_msg;
    TotalMsg.setText("" + total_msg);
    setNewMessage();
  }

  /**
   * Display a new message.
   */

  void setNewMessage(){
    KQMLmessage message = 
      (KQMLmessage)displayed_messages.elementAt(current_msg -1);
    CurrentMsg.setText("" + current_msg);
    Performative.setText(message.getValue("performative"));
    Sender.setText(message.getValue("sender"));
    Receiver.setText(message.getValue("receiver"));
    Language.setText(message.getValue("language"));
    Interpreter.setText(message.getValue("ontology"));
    Content.setText(message.getValue("content"));
    repaint();
  }
 
  /**
   * Called when an event happens. Currently used to identify
   * when buttons are pushed.
   * @param evt The event which triggered the method call.
   * @param arg Who called the method. For buttons, string name of button.
   */

  public boolean action(Event evt, Object arg) {
    if("Done".equals(arg)) {
      terminate();
    } else if(evt.target instanceof Choice){
      switchBuffers();
    } else if("Up Message".equals(arg)) {
      if(current_msg < total_msg) {
	current_msg++;
        setNewMessage();
      }
    } else if("Down Message".equals(arg)) {
      if(current_msg > 1) {
	current_msg--;
        setNewMessage();
      }
    }
    return true;
  }

}
