package JavaAgent.context;

import java.awt.*;
import java.util.Enumeration;
import java.util.Hashtable;
import java.net.URL;

/**
 * Panel opened by an AgentFrame which displays SystemMessages.<p>
 *
 * <hr>
 * Copyright (c) 1995, H. Robert Frost, Stanford University.
 * All rights reserved.<p>
 * Copyright (c) 1996, H. Robert Frost, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * <hr>
 * @author <A HREF="http://cdr.stanford.edu/html/people/frost-bio.html"> Rob Frost</A>
 * @version 0.3 5/21/96 for Java(tm) Language Version 1.0.2
 */

public class SystemMessagesPanel extends InterfacePanel {
  
  protected TextArea SystemMessages = new TextArea();
  protected Button Close = new Button("Close");

  /**
   * Creates an SystemMessagesPanel for a subclass of AgentFrame.
   * @param frame AgentFrame which created the panel
   */

  public SystemMessagesPanel(AgentFrame frame) {    
    super(frame);
    setLayout(new BorderLayout());
    add("Center",SystemMessages);
    add("South",Close);
    showMessages();
  }

  /**
   * Called when an event happens. Currently used to identify
   * when buttons are pushed.
   * @param evt The event which triggered the method call.
   * @param arg Who called the method. For buttons, string name of button.
   */
  
  public boolean action(Event evt, Object arg) {
    if("Close".equals(arg)) {
      terminate();
    } 
    
    return true;
  }

  private void showMessages(){
    Enumeration e = ((AgentFrame)parent).SystemMessageStorage.elements();
    while(e.hasMoreElements()){
      addSystemMessage((String)e.nextElement());
    }
  }

  /**
   * Displays the message in the SystemMessages TextArea.
   * @param message The message to output.
   */

  public void addSystemMessage(String message){
    SystemMessages.insertText(message + "\n", 0);
  }
  
}














