package JavaAgent.context;

import java.io.File;
import java.net.URL;
import java.util.Hashtable;

/**
 * Holds runtime parameters which govern the execution of an Agent and its
 * context. Additional parameters are contained in the ContextParams and
 * AgentParams classes. The fields of this class must be filled from
 * either commandline args or applet parameters.<p>
 *
 * <hr>
 * Copyright (c) 1995, H. Robert Frost, Stanford University.
 * All rights reserved.<p>
 * Copyright (c) 1996, H. Robert Frost, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * <hr>
 * @author <A HREF="http://cdr.stanford.edu/html/people/frost-bio.html"> Rob Frost</A>
 * @version 0.3 5/21/96 for Java(tm) Language Version 1.0.2
 */


public class RuntimeParams{

  /**
   * URL for the initialization file. This file will contain a set of 
   * KQML messages which initialize the state of the Agent. One of these 
   * messages must contain the address for the ANS.
   */
  public URL init_url = null;

  /**
   * URL for shared classes and files. This URL must have the http protocol.
   */
  public URL shared_url = null;

  /**
   * Directory for local access to shared classes.
   */
  public File working_dir = null;

  /**
   * Directory for storing working files in the local file system, will be 
   * null if the Agent is unable to write to the local file system.
   */
  public File shared_dir = null;

  /**
   * Name for the Agent. The name must be unique among all Agents administered
   * by a single ANS.
   */
  public String name = null;

  /**
   * Should a gui be created for this Agent?
   */
  public boolean gui = false;

  /**
   * True if the AgentContext was created by an Applet. 
   */
  public boolean applet = false;

  /**
   * Constructor for use with applets 
   */
  public RuntimeParams(){}

  /**
   * Constructor the RuntimeParams object. Takes a Hashtable containing 
   * parameter values as input.
   */
  public RuntimeParams(Hashtable args){

    if(args.containsKey("-i")){
      try{
	init_url = new URL((String)args.get("-i"));
      } catch (Exception e) {
	System.out.println("Invalid intialization file URL, " + e.toString());
	System.exit(0);
      }
    } else {
      System.out.println("You did not provide an intialization file URL.");
      System.exit(0);
    }

    if(args.containsKey("-gui")){
      gui = true;
    }
    
    if(args.containsKey("-s")){ 
      try{
	shared_url = new URL((String)args.get("-s"));
      } catch (Exception e){
	System.out.println("Invalid shared classes URL, " + e.toString());
	System.exit(0);
      }
    }

    if(args.containsKey("-l")){
      try{
	shared_dir = new File((String)args.get("-l"));
      } catch (Exception e){
	System.out.println("Invalid shared classes dir, " + e.toString());
	System.exit(0);
      }
    }
    
    if(args.containsKey("-w")){
      try{
	working_dir = new File((String)args.get("-w"));
      } catch (Exception e){
	System.out.println("Invalid working directory, " + e.toString());
	System.exit(0);
      }
    }
    
    if(args.containsKey("-n")){
      name = (String)args.get("-n");
    } 
    
  }

}
