package JavaAgent.context;

import java.awt.*;
import java.util.Enumeration;
import java.util.Hashtable;
import java.net.URL;

/**
 * Panel which allows a user to load a resource from a URL.<p>
 *
 * <hr>
 * Copyright (c) 1995, H. Robert Frost, Stanford University.
 * All rights reserved.<p>
 * Copyright (c) 1996, H. Robert Frost, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * <hr>
 * @author <A HREF="http://cdr.stanford.edu/html/people/frost-bio.html"> Rob Frost</A>
 * @version 0.3 5/21/96 for Java(tm) Language Version 1.0.2
 */

public class LoadResourcePanel extends InterfacePanel {
  
  protected Button LoadResource = new Button("Load Resource");
  protected Label TypeLabel = new Label("Resource Type:");
  protected Choice Type = new Choice();
  protected Label NameLabel = new Label("Resource Name:");
  protected TextField Name = new TextField(20);
  protected Label ClassLabel = new Label("Class/File Name:");
  protected TextField Class = new TextField(20);
  protected Button Done = new Button("Cancel");
  protected Label URLLabel = new Label("URL:");
  protected TextField ResourceURL = new TextField(20);

  /**
   * Creates LoadResourcePanel for a subclass of
   * AgentFrame.
   * @param frame The object for which the panel is created.
   */

  public LoadResourcePanel(AgentFrame frame) {
   
    super(frame);
    
    setLayout(new GridLayout(5,2,horiz_spacing, vert_spacing));
    
    add(TypeLabel);
    add(Type);
    add(NameLabel);
    add(Name);
    add(ClassLabel);
    add(Class);
    add(URLLabel);
    add(ResourceURL);
    add(LoadResource);
    add(Done);

    Type.addItem("language");
    Type.addItem("interpreter");
    Type.addItem("class");
    Type.addItem("file");
  }

  /**
   * Called when an event happens. Currently used to identify
   * when buttons are pushed.
   * @param evt The event which triggered the method call.
   * @param arg Who called the method. For buttons, string name of button.
   */

  public boolean action(Event evt, Object arg) {
    if("Cancel".equals(arg)) {
      terminate();
    } else if("Load Resource".equals(arg)) {
      parent.getAgent().loadResource(Type.getSelectedItem(),Name.getText()
			  ,Class.getText(),ResourceURL.getText());
      terminate();
    } 
    return true;
  }
  
}


