package JavaAgent.context;

import java.awt.*;
import java.util.Enumeration;
import java.util.Hashtable;
import java.net.URL;

/**
 * Panel which allows a user to load a set of KQMLmessages from a file.<p>
 * <hr>
 * Copyright (c) 1995, H. Robert Frost, Stanford University.
 * All rights reserved.<p>
 * Copyright (c) 1996, H. Robert Frost, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * <hr>
 * @author <A HREF="http://cdr.stanford.edu/html/people/frost-bio.html"> Rob Frost</A>
 * @version 0.3 5/21/96 for Java(tm) Language Version 1.0.2
 */

public class LoadMessagePanel extends InterfacePanel {
  
  protected Button AddAddress = new Button("Add Address");
  protected Button LoadMessages = new Button("Load Messages");
  protected Button Done = new Button("Cancel");
  protected Label URLLabel = new Label("URL:");
  protected TextField fileURL = new TextField(20);

  /**
   * Creates LoadMessagePanel for a subclass of AgentFrame.
   * @param frame The object for which the panel is created.
   */

  public LoadMessagePanel(AgentFrame frame) {
   
    super(frame);
    
    setLayout(new GridLayout(2,2,horiz_spacing, vert_spacing));

    add(URLLabel);
    add(fileURL);
    add(LoadMessages);
    add(Done);

  }

  /**
   * Called when an event happens. Currently used to identify
   * when buttons are pushed.
   * @param evt The event which triggered the method call.
   * @param arg Who called the method. For buttons, string name of button.
   */

  public boolean action(Event evt, Object arg) {
    if("Cancel".equals(arg)) {
      terminate();
    } else if("Load Messages".equals(arg)) {
      try {
	parent.getAgent().loadInitFile(new URL(fileURL.getText()));
      } catch (Exception e) {
	parent.addSystemMessage("Error loading addresses from file, " +
				e.toString());
      }
      terminate();
    } 
    return true;
  }
  
}














