package JavaAgent.context;

import java.awt.*;

/**
 * This is the super class for all panels which provide top-level 
 * interfaces for subclasses of AgentFrame.<p>
 *
 * <hr>
 * Copyright (c) 1995, H. Robert Frost, Stanford University.
 * All rights reserved.<p>
 * Copyright (c) 1996, H. Robert Frost, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * <hr>
 * @author <A HREF="http://cdr.stanford.edu/html/people/frost-bio.html"> Rob Frost</A>
 * @version 0.3 5/21/96 for Java(tm) Language Version 1.0.2
 */

public class InterfacePanel extends Panel {

  protected AgentFrame parent;
  protected static final int horiz_spacing = 10;
  protected static final int vert_spacing = 10;

  /**
   * Constructs a panel for a subclass of AgentFrame.
   * @param frame AgentFrame which the panel represents.
   */

  protected InterfacePanel(AgentFrame frame) {
    super();
    parent = frame;
  }

  /**
   * Disposes of the frame and kills the panel.
   */

  protected void terminate(){
    Frame f = (Frame)getParent();
    f.dispose();
    parent.killPanel(this);
  }

  /**
   * Called when a displayed resource has changed.
   */

  protected void resourceChanged(String type){
  }
  
}
