package JavaAgent.context;

/**
 * Static class which defines constant parameters for classes in the
 * JavaAgent.context package.
 * Some of these parameters serve as default values
 * which may be optionally overridden using commandline/applet parameters.<p>
 *
 * Parameters which need to be bound during compilation (i.e. inlined into 
 * the byte code) (e.g. booleans which 
 * control conditionally compiled code blocks) need to be declared
 * static final, those which need to be dynamically bound must be declared 
 * with only the static modifier. Most params will fall in the later category.
 * Note: compilation binding requires the recompilation of all affected
 * classes. <p>
 * <hr>
 * Copyright (c) 1995, H. Robert Frost, Stanford University.
 * All rights reserved.<p>
 * Copyright (c) 1996, H. Robert Frost, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * <hr>
 * @author <A HREF="http://cdr.stanford.edu/html/people/frost-bio.html"> Rob Frost</A>
 * @version 0.3 5/21/96 for Java(tm) Language Version 1.0.2
 */

public class ContextParams {

  /**
   * If true, all conditionally enclosed code blocks will be compiled and
   * executed during interpretation. If 
   * false, these blocks will be ignored by the compiler.
   * All effected classes must be recompiled for this change
   * to take place. 
   */

  public static final boolean TEST = false;

  /**
   * Should detailed systems messages be printed?
   */

  public static boolean DEBUG = true;

  /**
   * Should exception stack traces be printed?
   */

  public static boolean STACK_TRACE = true;

  /**
   * Should system messages be written to a log file.
   */

  public static boolean LOG_FILE = true;
  
  /**
   * Default port for ServerSocket creation, 0 indicates that the port 
   * should be automatically selected.
   */
  
  public static int PORT = 0;

  /**
   * Window sizes
   */

  public static int AF_WIDTH = 300;
  public static int AF_HEIGHT = 225;
  public static int COMP_MESS_WD = 275;
  public static int COMP_MESS_HT = 500;
  public static int VIEW_MESS_WD = 275;
  public static int VIEW_MESS_HT = 500;
  public static int LOAD_MESS_WD = 300;
  public static int LOAD_MESS_HT = 100;
  public static int VIEW_RES_WD = 200; 
  public static int VIEW_RES_HT = 300;
  public static int LOAD_RES_WD = 300;
  public static int LOAD_RES_HT = 225;
  public static int SMP_WIDTH = 300;
  public static int SMP_HEIGHT = 250;  

}
