package JavaAgent.context;

import java.awt.Panel;

/**
 * Interface through which the Agent can communicate information to the 
 * context.<p>
 *
 * <hr>
 * Copyright (c) 1995, H. Robert Frost, Stanford University.
 * All rights reserved.<p>
 * Copyright (c) 1996, H. Robert Frost, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * <hr>
 * @author <A HREF="http://cdr.stanford.edu/html/people/frost-bio.html"> Rob Frost</A>
 * @version 0.3 5/21/96 for Java(tm) Language Version 1.0.2
 */

public interface ContextInterface{

  /**
   * Sends a system message to the context.
   * @param message The string message.
   */

  public void addSystemMessage(String message);


  /**
   * Sends a system message w/ an optional exception.
   * @param message The string message.
   * @param e Exception which generated the message, may be null.
   */

  public void addSystemMessage(String message, Exception e);

  /**
   * Informs the context that one of the Agent's resources has changed.
   * @param type String identifying the type of the resource.
   */

  public void resourceChanged(String type);

  /**
   * Generic method for sending an Object message to some context-dependent
   * non-agent destination (e.g. a legacy software application, database,
   * etc.) Where this message is sent and how it is 
   * interpreted depends on the specific ContextInterface implementation.
   * If no destination exists or some other problem occurs,
   * a NonAgentMsgException will be thrown. 
   * @message Object representing the message.
   */
  public void NonAgentMsg(Object message) throws NonAgentMsgException;

  /**
   * Returns true if the context supports a GUI.
   * @return True if the context has a GUI, false otherwise. 
   */

  public boolean hasGUI();

  /**
   * If the context supports a GUI, then adds the instantiated and intialized
   * panel to a new top-level window.
   * @param p Panel to add.
   */

  public void addPanel(Panel p);

  /**
   * Called by Agent to indicate that the name has changed.
   * @param name The new name
   */

  public void setName(String name);

  /**
   * Called by Agent to indicate termination.
   */
  
  public void terminate();


}




