package JavaAgent.context;

import JavaAgent.resource.KQMLmessage;

import java.io.*;
import java.awt.*;

/**
 * Panel which allows a user to create a KQML message.<p>
 *
 * <hr>
 * Copyright (c) 1995, H. Robert Frost, Stanford University.
 * All rights reserved.<p>
 * Copyright (c) 1996, H. Robert Frost, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * <hr>
 * @author <A HREF="http://cdr.stanford.edu/html/people/frost-bio.html"> Rob Frost</A>
 * @version 0.3 5/21/96 for Java(tm) Language Version 1.0.2
 */

public class ComposeMessagePanel extends InterfacePanel {
 
  protected Panel ButtonPanel = new Panel();
  protected Panel ContentPanel = new Panel();
  protected Button SendMessage = new Button("Send Message");
  protected Button Cancel = new Button("Cancel");
  protected TextField Sender = new TextField(20);
  protected Label SenderLabel = new Label("Sender");
  protected TextField Receiver = new TextField(20);
  protected Label ReceiverLabel = new Label("Receiver");
  protected TextField Performative = new TextField(20);
  protected Label PerformativeLabel = new Label("Performative");
  protected TextField Language = new TextField(20);
  protected Label LanguageLabel=  new Label("Language"); 
  protected TextField Interpreter = new TextField(20);
  protected Label InterpreterLabel= new Label("Ontology"); 
  protected TextArea Content = new TextArea();
  protected Label ContentLabel = new Label("Content"); 
  protected KQMLmessage m = new KQMLmessage();
  protected Button LoadMessage = new Button("Load Message");

  /**
   * Constructs a ComposeMessagePanel for a subclass of AgentFrame with 
   * the specified default KQMLmessage.
   * @param frame AgentFrame to which the panel is connected.
   * @param message Default KQMLmessage.
   */

  public ComposeMessagePanel(AgentFrame frame, KQMLmessage message) {
   
    super(frame);

    if(message != null){
      m = message;
    }

    setLayout(new BorderLayout());
    add("North",ButtonPanel);
    add("Center",ContentPanel);
    add("South",LoadMessage);
    
    ButtonPanel.setLayout(new GridLayout(6,2, horiz_spacing, vert_spacing));
    ContentPanel.setLayout(new BorderLayout());
   
    ButtonPanel.add(SendMessage);
    ButtonPanel.add(Cancel); 

    ButtonPanel.add(PerformativeLabel);
    Performative.setEditable(true);
    Performative.setText(m.getValue("performative"));
    ButtonPanel.add(Performative);
   
    ButtonPanel.add(SenderLabel);
    Sender.setEditable(true);
    Sender.setText(m.getValue("sender"));
    ButtonPanel.add(Sender);
    
    ButtonPanel.add(ReceiverLabel);
    Receiver.setEditable(true);
    Receiver.setText(m.getValue("receiver"));
    ButtonPanel.add(Receiver);

    ButtonPanel.add(LanguageLabel);
    Language.setEditable(true);
    Language.setText(m.getValue("language"));
    ButtonPanel.add(Language);
  
    ButtonPanel.add(InterpreterLabel);
    Interpreter.setEditable(true);
    Interpreter.setText(m.getValue("ontology"));
    ButtonPanel.add(Interpreter);

    ContentPanel.add("North",ContentLabel);
    Content.setEditable(true);
    Content.setText(m.getValue("content"));
    ContentPanel.add("Center",Content);
    
  }

  /**
   * Check to see if values have been entered for all fields.
   */

  boolean checkValid() {
    boolean answer = false;
    if( (Performative.getText().length() > 0) &&
	(Sender.getText().length() > 0) &&
	(Receiver.getText().length() > 0) &&
	(Language.getText().length() > 0) &&
	(Interpreter.getText().length() > 0) &&
	(Content.getText().length() > 0)) {
      answer = true;
    }
    return answer;
  }
  
  /**
   * Called when an event happens in the AgentApplet. Currently used to
   * identify when buttons are pushed.
   *
   * @param evt The event which triggered the method call.
   * @param arg Who called the method. For buttons, string name of button.
   */

  public boolean action(Event evt, Object arg) {
    if("Send Message".equals(arg)) {
      if( checkValid()) { 
	try {
	  KQMLmessage message = new KQMLmessage();
	  message.addFieldValuePair("performative", Performative.getText());
	  message.addFieldValuePair("sender", Sender.getText());
	  message.addFieldValuePair("receiver", Receiver.getText());
	  message.addFieldValuePair("language", Language.getText());
	  message.addFieldValuePair("ontology", Interpreter.getText());
	  message.addFieldValuePair("content", Content.getText());
	  parent.getAgent().sendMessage(message);
	} catch (Exception e) {
	  parent.addSystemMessage("Error creating KQMLmessage, message" +
				  " not sent, " + e.toString());
	}
      }
    } else if ("Load Message".equals(arg)) {
      FileDialog fileSelector = 
	  new FileDialog(parent, "Load KQML message", FileDialog.LOAD);
      fileSelector.show();
      String select = fileSelector.getDirectory() + fileSelector.getFile();
      try {
	BufferedReader msgFile = new BufferedReader(new FileReader(select));
	KQMLmessage msg = new KQMLmessage(msgFile.readLine());
	Performative.setText(msg.getValue("performative"));
	Receiver.setText(msg.getValue("receiver"));
	Language.setText(msg.getValue("language"));
	Interpreter.setText(msg.getValue("ontology"));
	Content.setText(msg.getValue("content"));
	msgFile.close();
      } catch (Exception e) {
	parent.addSystemMessage("Error loading message from " + select + '!');
      }
    } else if ("Cancel".equals(arg)) {
      terminate();
    }
    return true;
  }
}


