package JavaAgent.context;

import java.awt.*;
import java.applet.Applet;
import java.net.URL;
import java.io.File;

/**
 * AgentApplet is a subclass of Applet which creates a SocketContext object.
 * All of the constructor args for SocketContext must be provided as 
 * applet parameters. The following parameters are supported:<p>
 * <ul>
 * <li>"init_file_url"
 * <li>["shared_url"]
 * <li>["shared_dir"]
 * <li>["working_dir"]
 * <li>["gui"]
 * <li>["port"]
 * <li>["name"]
 * </ul><p>
 *
 * <hr>
 * Copyright (c) 1995, H. Robert Frost, Stanford University.
 * All rights reserved.<p>
 * Copyright (c) 1996, H. Robert Frost, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * <hr>
 * @author <A HREF="http://cdr.stanford.edu/html/people/frost-bio.html"> Rob Frost</A>
 * @version 0.3 5/21/96 for Java(tm) Language Version 1.0.2
 */

public class AgentApplet extends Applet {

  /**
   * SocketContext which this applet creates.
   */
  protected SocketContext context;
  
  /**
   * Parameters which govern execution.
   */
  protected SocketParams params = new SocketParams();
  
  /**
   * Constructor for an AgentApplet. Creates a button for creating an
   * AgentContext.
   */
  
  public AgentApplet(){
    setLayout(new BorderLayout());
    add("Center", new Button("Create Agent"));
  }

  /**
   * Get the parameters.
   */
  
  public void init(){
 
    String init_file_str = getParameter("init_file_url");
    String shared_url_str = getParameter("shared_url");
    String shared_dir_str = getParameter("shared_dir");
    String working_dir_str = getParameter("working_dir");
    String gui_str = getParameter("gui");
    String name = getParameter("name");
    String port_str = getParameter("port");

    if(init_file_str != null){
      try{
	params.init_url = new URL(init_file_str);
      } catch (Exception e) {
	System.out.println("Invalid intialization file URL, " + e.toString());
	stop();
      }
    } else {
      System.out.println("You did not provide an intialization file URL.");
      stop();
    }

    if(gui_str != null){
      params.gui = gui_str.equals("true")?true:false;
    }
    
    if(shared_url_str != null){ 
      try{
	params.shared_url = new URL(shared_url_str);
      } catch (Exception e){
	System.out.println("Invalid shared classes URL, " + e.toString());
	stop();
      }
    }

    if(shared_dir_str != null){ 
      try{
	params.shared_dir = new File(shared_dir_str);
      } catch (Exception e){
	System.out.println("Invalid shared classes dir, " + e.toString());
	stop();
      }
    }
    
    if(working_dir_str != null){
      try{
	params.working_dir = new File(working_dir_str);
      } catch (Exception e){
	System.out.println("Invalid working directory, " + e.toString());
	stop();
      }
    }
    
    if(port_str != null){
      params.port = (new Integer(port_str)).intValue();
    }

    if(name == null){
      params.name = "Agent";
    } else {
      params.name = name;
    }

    params.applet = true;

    super.init();
  }

  /**
   * Called when an event happens in the AgentApplet.
   * @param evt The event which triggered the method call.
   * @param arg Who called the method. For buttons, string name of button.
   */

  public boolean action(Event evt, Object arg) {
    if("Create Agent".equals((String)arg)) {      
      SocketContext sc = new SocketContext(params);
    }
    return true;
  }

}



