package JavaAgent.context;

import JavaAgent.agent.*;
import JavaAgent.resource.*;
import java.io.*;
import java.net.*;
import java.util.*;

/**
 * Subclass of SocketContext which creates an ANS.<p>
 *
 * <hr>
 * Copyright (c) 1995, H. Robert Frost, Stanford University.
 * All rights reserved.<p>
 * Copyright (c) 1996, H. Robert Frost, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * <hr>
 * @author <A HREF="http://cdr.stanford.edu/html/people/frost-bio.html"> Rob Frost</A>
 * @version 0.3 5/21/96 for Java(tm) Language Version 1.0.2
 */

public class ANSContext extends SocketContext {

  /**
   * Sets the parameters and creates the
   * CommInterface, represented Agent and possibly the AgentFrame.
   * @param params Runtime parameters for the AgentContext.
   */

  public ANSContext(SocketParams params){
    super(params);
  }

  /**
   * Creates the ANS object.
   */  
  
  protected boolean addAgent(){
    
    if( params.init_url != null){
      A = new ANS(this,"ANS", 
		  params.init_url, params.shared_url, 
		  params.shared_dir, params.working_dir);
      A.init();
      return true;
    } else {
      addSystemMessage("Do not have location of initialization file!");
    }
    return false;
  }

  /**
   * Creates a SocketInterface for the ANS, uses the address contained in
   * the initialization file.
   */

  protected void createCommInterface(){
    try{
      SocketAddress sa = 
	(SocketAddress)(A.getResource("address")).getElement("ANS",
							     RetrievalResource.BLOCK);
      if(sa != null){
	if(hostMatch(sa)){    
	  comm = new SocketInterface(A,sa.port); 
	  if(((SocketInterface)comm).port >= 0){
	    comm_ready = true;
	    A.setComm(comm);
	  } else {
	    addSystemMessage("Failed to create a Socket Interface for the" + 
			     " ANS on port " + sa.port +
			     ", try a different port.");      
	  }
	} else {
	  addSystemMessage("Trying to start the ANS on a host not listed in" +
			   " the initialization file. Correct the init file" +
			   " or switch to the proper host.");
	}
      } else {
	addSystemMessage("No address for ANS in init file! \n" +
			 "The init file must contain an address for the ANS!");
      }
    } catch (ResourceException e){
      addSystemMessage("Error getting address for ANS.", e);
    }
  }

  /**
   * Checks to see if the current host is the same as the host listed in
   * the init file.
   * @param sa SocketAddress listed in the init_file.
   */
  
  protected boolean hostMatch(SocketAddress sa){
    
    String host;
    try{
      InetAddress IPaddress = InetAddress.getLocalHost();
      host = IPaddress.getHostName();
      if(sa.host.equals(IPaddress.toString().substring(IPaddress.toString().indexOf("/") + 1))){
	return true;
      } else if(host.indexOf(".") < 0){
       	String address_host = sa.host.substring(0,sa.host.indexOf("."));
	if(address_host.equalsIgnoreCase(host)){
	  return true;
	}
      } else if(sa.host.equalsIgnoreCase(host)){
	return true;
      }
	 
    } catch(Exception e){
      addSystemMessage("Host match failed.", e);
      return false;
    }
    addSystemMessage("Host match failed, real host = " + host + ", " +
		     "specified host = " + sa.host);
    return false;
  }

  /**
   * Called if the ANSContext is started as an application from the command
   * line. Command line args:<p><ul>
   * <li> -i init_file URL
   * <li> [-s] shared classes URL, for classes and other files which will
   * be shared with other agents.
   * <li> [-l] local directory for writing to the shared classes URL.
   * <li> [-w] working directory for saving local files, this should not
   * be included if the agent cannot access the local disk 
   * <li> [-n] name, only included if the Agent should automatically 
   * connect to the network.
   * <li> [-gui] create a GUI if this flag is included
   * <li> [-p] For for ServerSocket
   * </ul>
   * @param arg Array of command line arguments.
   */

  public static void main(String arg[]) {
    Hashtable args = AgentContext.parseArgs(arg);
    ANSContext ans = new ANSContext(new SocketParams(args));
  }

}



















