package JavaAgent.agent;

import JavaAgent.resource.KQMLmessage;
import java.util.Vector;

/**
 * Class which provides synchronized storage for both incoming and outgoing 
 * messages. The add and remove methods are synchronized.<p>
 * 
 * <hr>
 * Copyright (c) 1995, H. Robert Frost, Stanford University.
 * All rights reserved.<p>
 * Copyright (c) 1996, H. Robert Frost, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * <hr>
 * @author <A HREF="http://cdr.stanford.edu/html/people/frost-bio.html"> Rob Frost</A>
 * @version 0.3 5/21/96 for Java(tm) Language Version 1.0.2
 */

public class MessageBuffer {

  private Vector messages = new Vector();

  /**
   * Add a message to the buffer.
   * @param m Message to be processed.
   */

  synchronized public void add(KQMLmessage m){
    if(m == null){
      System.out.println("Message is null");
    } else {
      messages.addElement(m);    
      notify();
    }
  }

  /**
   * Remove a message for processing.
   * @return Message to process.
   */

  synchronized public KQMLmessage get(){
    while(messages.size() <= 0){
      try{
	wait();
      } catch (InterruptedException e){}
    }
    KQMLmessage msg = (KQMLmessage)messages.elementAt(0);
    messages.removeElement(msg);
    return msg;
  }

}
