package JavaAgent.agent;

import JavaAgent.resource.KQMLmessage;
import java.util.Hashtable;

/**
 * Abstract class which provides an interface between an Agent
 * and the actual 
 * mechanisms used for message passing. Allows the agent to send messages and
 * informs the agent when messages have been recieved.  When a message is 
 * received, the CommInterface must parse the message
 * to create a KQMLmessage object and then call the 
 * receiveMessage() method of the Agent.
 * When the Agent calls the
 * sendMessage() method of the CommInterace, the CommInterface will attempt
 * to send the message and call the Agents's sendResult() method to 
 * report the success or failure of the transmission.<p>
 *
 * <hr>
 * Copyright (c) 1995, H. Robert Frost, Stanford University.
 * All rights reserved.<p>
 * Copyright (c) 1996, H. Robert Frost, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * <hr>
 * @author <A HREF="http://cdr.stanford.edu/html/people/frost-bio.html"> Rob Frost</A>
 * @version 0.3 5/21/96 for Java(tm) Language Version 1.0.2
 */

public abstract class CommInterface {

  protected Agent parent;
 
  /**
   * Contructs a CommInterace for a specific Agent.
   * @param A Agent which this CommInterface represents.
   */

  public CommInterface(Agent A){
    parent = A;
  }
  
  /**
   * Called to send a given KQMLmessage. Actual mechanism must be 
   * implemented separately.
   * @param message The KQMLmessage to send.
   */

  abstract protected void sendMessage (KQMLmessage message);

  /**
   * Called by the Agent to disconnect the CommInterface.
   */

  abstract protected void disconnect();
 
}
