package JavaAgent.agent;

/**
 * Static class which defines constant parameters for classes in the
 * JavaAgent.agent and JavaAgent.resource packages.
 * Some of these parameters serve as default values
 * which may be optionally overridden using commandline/applet parameters.<p>
 *
 * Parameters which need to be bound during compilation (i.e. inlined into 
 * the byte code) (e.g. booleans which 
 * control conditionally compiled code blocks) need to be declared
 * static final, those which need to be dynamically bound must be declared 
 * with only the static modifier. Most params will fall in the later category.
 * Note: compilation binding requires the recompilation of all affected
 * classes. <p>
 * 
 * <hr>
 * Copyright (c) 1995, H. Robert Frost, Stanford University.
 * All rights reserved.<p>
 * Copyright (c) 1996, H. Robert Frost, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * <hr>
 * @author <A HREF="http://cdr.stanford.edu/html/people/frost-bio.html"> Rob Frost</A>
 * @version 0.3 5/21/96 for Java(tm) Language Version 1.0.2
 */

public class AgentParams {

  /**
   * If true, all conditionally enclosed code blocks will be compiled and
   * executed during interpretation. If 
   * false, these blocks will be ignored by the compiler.
   * All effected classes must be recompiled for this change
   * to take place. 
   */

  public static final boolean TEST = false;

  /**
   * Should detailed systems messages be printed?
   */

  public static boolean DEBUG = true;

  /**
   * Max size of the messages_in and messages_out buffers.
   */

  protected static int MESSAGE_STORAGE = 100;

  /**
   * Timeout value for sending a message, in milliseconds.
   */

  protected static int SEND_TIMEOUT = 3000;

  /**
   * Timeout value for receiving a message, in milliseconds.
   */

  protected static int RECEIVE_TIMEOUT = 5000;

  /**
   * If the file already exists, don't modify it.
   */

  public static final char LEAVE = 0;

  /**
   * If the file exists, replace it with the remote file.
   */

  public static final char OVERWRITE = 1;

  /**
   * If the file exists, append the remote file onto the local file.
   */

  public static final char APPEND = 2;

  /**
   * Should existing files be left, overwritten or appended to when performing
   * a remote copy?
   */

  public static int FILE_EXISTS_ACTION = OVERWRITE;

  /**
   * Resource retrieval max wait.
   */
  public static long RETRIEVAL_WAIT = 5000;

  /**
   * Max number of notifies to wait through for resource retrieval.
   */
  public static int RETRIEVAL_NOTIFIES = 5;

}
